<?php

class  Pagination
{

    private $config;
    private $CI;

    /**
     * Pagination constructor.
     * @param $url
     * @param $num_rows
     * @param $perpage
     * @param $num_links
     */
    public function __construct($url, $num_rows, $perpage, $num_links)
    {
        $this->CI = get_instance();
        $this->CI->load->library('pagination');

        $this->config['total_rows'] = $num_rows;
        $this->config['base_url'] = $url;
        $this->config['per_page'] = $perpage;
        $this->config['num_links'] = $num_links;
        $this->config['full_tag_open'] = "<ul class='pagination center'>";
        $this->config['full_tag_close'] = '</ul>';
        $this->config['num_tag_open'] = '<li>';
        $this->config['num_tag_close'] = '</li>';
        $this->config['cur_tag_open'] = '<li class="active indigo"><a href="#">';
        $this->config['cur_tag_close'] = '</a></li>';
        $this->config['prev_tag_open'] = '<li> ';
        $this->config['prev_tag_close'] = '</li>';
        $this->config['first_tag_open'] = '<li>';
        $this->config['first_tag_close'] = '</li>';
        $this->config['last_tag_open'] = '<li>';
        $this->config['last_tag_close'] = '</li> ';
        $this->config['reuse_query_string'] = true;
        $this->config['page_query_string'] = false;


    }

    /**
     * Inicializa la paginacion con los datos personalizados de config
     */
    public function init_pagination()
    {
        $this->CI->pagination->initialize($this->config);
    }


}